<?php
return [
    'app' => [
        'name' => 'Venta y Compra - Taller Mecánico Mojarra',
        'base_url' => '/',
        'timezone' => 'America/La_Paz',
        'items_per_page' => 20,
        'max_images_per_listing' => 8,
        'currency' => 'BOB',
        'maintenance_mode' => false,
    ],
    'security' => [
        'session_name' => 'mojarra_session',
        'csrf_key' => 'mojarra_csrf',
        'rate_limit' => [
            'login' => ['attempts' => 6, 'window' => 900],
            'register' => ['attempts' => 5, 'window' => 1800],
        ],
        'password_algo' => PASSWORD_BCRYPT,
    ],
    'paths' => [
        'storage' => __DIR__ . '/../storage',
        'public' => __DIR__ . '/../public',
        'logs' => __DIR__ . '/../storage/logs',
        'cache' => __DIR__ . '/../storage/cache',
    ],
    'defaults' => [
        'superadmin_email' => 'superadmin@mojarra.local',
        'admin_email' => 'admin@mojarra.local',
    ],
];
