<?php
namespace App\Core;

class Controller
{
    public function __construct(
        protected array $config,
        protected Storage $storage,
        protected Auth $auth,
        protected Security $security
    ) {
    }

    protected function view(string $view, array $data = []): void
    {
        extract($data);
        $config = $this->config;
        $auth = $this->auth;
        $security = $this->security;
        $storage = $this->storage;

        ob_start();
        require __DIR__ . '/../views/' . $view . '.php';
        $content = ob_get_clean();

        ob_start();
        require __DIR__ . '/../views/layouts/main.php';
        $html = ob_get_clean();

        $base = Helpers::baseUrl();
        if ($base !== '/') {
            $prefix = preg_quote($base, '#');
            $html = preg_replace_callback(
                '#\b(href|src|action)=([\'"])(/[^\'"]*)\2#i',
                static function (array $m) use ($base, $prefix): string {
                    if (preg_match('#^' . $prefix . '(?:/|$)#', $m[3]) === 1) {
                        return $m[0];
                    }
                    return $m[1] . '=' . $m[2] . $base . $m[3] . $m[2];
                },
                $html
            );
        }

        echo $html;
    }

    protected function json(array $data, int $status = 200): void
    {
        http_response_code($status);
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    protected function input(string $key, $default = null)
    {
        return $_POST[$key] ?? $_GET[$key] ?? $default;
    }
}
