<?php
namespace App\Core;

class Helpers
{
    public static function baseUrl(): string
    {
        $base = $GLOBALS['__app_base_url'] ?? '/';
        $base = is_string($base) ? trim($base) : '/';
        if ($base === '' || $base === '.') {
            return '/';
        }
        if ($base[0] !== '/') {
            $base = '/' . $base;
        }
        return rtrim($base, '/') ?: '/';
    }

    public static function url(string $path = '/'): string
    {
        if ($path === '') {
            return self::baseUrl();
        }
        if (preg_match('#^(?:https?:)?//#i', $path)) {
            return $path;
        }
        if ($path[0] !== '/') {
            $path = '/' . $path;
        }
        $base = self::baseUrl();
        if ($base === '/') {
            return $path;
        }
        return $base . $path;
    }

    public static function now(): int
    {
        return time();
    }

    public static function randomId(string $prefix): string
    {
        return $prefix . '_' . bin2hex(random_bytes(6));
    }

    public static function slug(string $text): string
    {
        $text = strtolower(trim($text));
        $text = preg_replace('/[^a-z0-9\s-]/', '', $text) ?? '';
        $text = preg_replace('/\s+/', '-', $text) ?? '';
        $text = preg_replace('/-+/', '-', $text) ?? '';
        return trim($text, '-') ?: 'item';
    }

    public static function e(?string $value): string
    {
        return htmlspecialchars((string) $value, ENT_QUOTES, 'UTF-8');
    }

    public static function redirect(string $path): void
    {
        header('Location: ' . self::url($path));
        exit;
    }

    public static function flash(string $key, ?string $value = null): ?string
    {
        if ($value !== null) {
            $_SESSION['_flash'][$key] = $value;
            return null;
        }
        $out = $_SESSION['_flash'][$key] ?? null;
        unset($_SESSION['_flash'][$key]);
        return $out;
    }
}
