<?php
namespace App\Core;

class Security
{
    public function __construct(private array $config, private Storage $storage)
    {
    }

    public function csrfToken(): string
    {
        $key = $this->config['security']['csrf_key'];
        if (empty($_SESSION[$key])) {
            $_SESSION[$key] = bin2hex(random_bytes(16));
        }
        return $_SESSION[$key];
    }

    public function verifyCsrf(?string $token): bool
    {
        $sessionToken = $_SESSION[$this->config['security']['csrf_key']] ?? '';
        return is_string($token) && hash_equals($sessionToken, $token);
    }

    public function rateLimit(string $action): bool
    {
        $rules = $this->config['security']['rate_limit'][$action] ?? null;
        if (!$rules) {
            return true;
        }

        $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $key = 'rate_' . $action . '_' . md5($ip);
        $store = $this->storage->readJson('sessions/rate_limits.json', []);
        $entry = $store[$key] ?? ['count' => 0, 'start' => time()];
        $now = time();

        if (($now - $entry['start']) > $rules['window']) {
            $entry = ['count' => 0, 'start' => $now];
        }

        $entry['count']++;
        $store[$key] = $entry;
        $this->storage->writeJson('sessions/rate_limits.json', $store);

        return $entry['count'] <= $rules['attempts'];
    }
}
