<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad" class="active"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-ad"></i> Publicidad y Slots</h1>
    </div>

    <div class="admin-card">
      <h3><i class="fas fa-plus"></i> Nuevo slot publicitario</h3>
      <form method="post" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">Clave del slot</label>
            <input name="key" placeholder="home_top, sidebar_1, listing_inline..." required>
          </div>
          <div class="form-group">
            <label class="form-label">Tipo</label>
            <select name="type">
              <option value="banner">Banner (imagen/HTML)</option>
              <option value="adsense">AdSense (código JS)</option>
            </select>
          </div>
        </div>
        <div class="form-group">
          <label class="form-label">Código HTML/JS</label>
          <textarea name="code" rows="4" placeholder="Pega aquí el código del banner o AdSense..."></textarea>
        </div>
        <label style="display:flex;align-items:center;gap:.5rem;margin:.5rem 0">
          <input type="checkbox" name="enabled" checked> Habilitado
        </label>
        <button type="submit"><i class="fas fa-save"></i> Guardar slot</button>
      </form>
    </div>

    <div class="admin-card" style="margin-top:1rem">
      <h3>Slots configurados (<?= count($slots) ?>)</h3>
      <?php if (empty($slots)): ?>
      <p class="text-muted" style="margin-top:.5rem">No hay slots configurados aún.</p>
      <?php else: ?>
      <div class="table-responsive" style="margin-top:1rem">
        <table class="admin-table">
          <thead>
            <tr><th>Clave</th><th>Tipo</th><th>Estado</th></tr>
          </thead>
          <tbody>
            <?php foreach($slots as $s): ?>
            <tr>
              <td><code><?= Helpers::e($s['key']) ?></code></td>
              <td><?= Helpers::e($s['type']) ?></td>
              <td><span class="status-badge <?= !empty($s['enabled']) ? 'status-approved' : 'status-hidden' ?>"><?= !empty($s['enabled']) ? 'Activo' : 'Inactivo' ?></span></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
