<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand">
      <i class="fas fa-shield-halved"></i> Panel Admin
    </div>
    <nav class="admin-nav">
      <a href="/admin" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-tachometer-alt"></i> Dashboard Administrativo</h1>
    </div>

    <div class="stats-grid">
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--warning)"><i class="fas fa-hourglass-half"></i></div>
        <div class="stat-number"><?= (int)$stats['pending'] ?></div>
        <div class="stat-label">Pendientes</div>
        <a href="/admin/publicaciones?estado=pending" class="stat-link">Ver cola <i class="fas fa-arrow-right"></i></a>
      </div>
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--success)"><i class="fas fa-check-circle"></i></div>
        <div class="stat-number"><?= (int)$stats['approvedToday'] ?></div>
        <div class="stat-label">Aprobadas hoy</div>
      </div>
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--secondary)"><i class="fas fa-users"></i></div>
        <div class="stat-number"><?= (int)$stats['newUsers'] ?></div>
        <div class="stat-label">Usuarios nuevos</div>
      </div>
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--danger)"><i class="fas fa-flag"></i></div>
        <div class="stat-number"><?= (int)$stats['reports'] ?></div>
        <div class="stat-label">Reportes abiertos</div>
        <a href="/admin/reportes" class="stat-link">Ver reportes <i class="fas fa-arrow-right"></i></a>
      </div>
    </div>

    <div class="admin-card" style="margin-top:1.5rem">
      <h3><i class="fas fa-tools"></i> Acciones rápidas</h3>
      <div style="display:flex;gap:1rem;flex-wrap:wrap;margin-top:1rem">
        <a href="/admin/publicaciones?estado=pending" class="btn-glow"><i class="fas fa-clipboard-check"></i> Moderar publicaciones</a>
        <a href="/admin/categorias" class="btn-outline"><i class="fas fa-folder-plus"></i> Gestionar categorías</a>
        <form method="post" action="/admin/rebuild-indexes" class="inline-form">
          <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
          <button type="submit" class="btn-outline"><i class="fas fa-sync"></i> Reconstruir índices</button>
        </form>
      </div>
    </div>

    <div class="admin-card" style="margin-top:1.5rem">
      <h3><i class="fas fa-chart-bar"></i> Resumen</h3>
      <p class="text-muted" style="margin-top:.5rem">Total de publicaciones en el sistema: <strong><?= (int)$stats['totalListings'] ?></strong></p>
    </div>
  </div>
</div>
