<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending" class="active"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-clipboard-check"></i> Moderación de publicaciones</h1>
    </div>

    <!-- Status Tabs -->
    <div class="tab-bar">
      <?php
      $tabs = ['pending' => 'Pendientes', 'approved' => 'Aprobadas', 'rejected' => 'Rechazadas', 'sold' => 'Vendidos', 'todos' => 'Todos'];
      foreach ($tabs as $key => $label):
      ?>
      <a href="/admin/publicaciones?estado=<?= $key ?>" class="tab-btn <?= ($status ?? 'pending') === $key ? 'active' : '' ?>">
        <?= $label ?>
      </a>
      <?php endforeach; ?>
    </div>

    <?php if (empty($items)): ?>
    <div class="empty-state">
      <i class="fas fa-inbox"></i>
      <h3>No hay publicaciones con este estado</h3>
    </div>
    <?php else: ?>
    <div class="data-list">
      <?php foreach($items as $it): ?>
      <div class="data-item">
        <div class="data-item-header">
          <div>
            <h3><?= Helpers::e($it['title']) ?></h3>
            <div class="data-item-meta">
              <span class="status-badge status-<?= Helpers::e($it['status'] ?? 'pending') ?>"><?= Helpers::e(ucfirst($it['status'] ?? 'pending')) ?></span>
              <span class="text-muted"><i class="fas fa-folder"></i> <?= Helpers::e(ucfirst($it['category'] ?? '')) ?></span>
              <span class="text-muted"><i class="fas fa-user"></i> <?= Helpers::e($it['ownerId'] ?? '') ?></span>
              <span class="text-muted"><i class="fas fa-calendar"></i> <?= date('d/m/Y', (int)($it['createdAt'] ?? 0)) ?></span>
              <?php if (!empty($it['featured'])): ?><span class="badge badge-featured"><i class="fas fa-star"></i> Destacado</span><?php endif; ?>
            </div>
          </div>
          <div class="listing-card-price"><?= number_format((float)($it['price'] ?? 0), 0, ',', '.') ?> BOB</div>
        </div>

        <!-- Quick Actions -->
        <div class="data-item-actions">
          <?php if (($it['status'] ?? '') !== 'approved'): ?>
          <form class="inline-form" method="post" action="/admin/publicacion/aprobar?id=<?= Helpers::e($it['id']) ?>">
            <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
            <button type="submit" class="btn-sm btn-success"><i class="fas fa-check"></i> Aprobar</button>
          </form>
          <?php endif; ?>

          <?php if (($it['status'] ?? '') !== 'rejected'): ?>
          <form class="inline-form" method="post" action="/admin/publicacion/rechazar?id=<?= Helpers::e($it['id']) ?>">
            <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
            <input name="reason" placeholder="Motivo de rechazo" style="width:200px">
            <button type="submit" class="btn-sm btn-danger"><i class="fas fa-times"></i> Rechazar</button>
          </form>
          <?php endif; ?>

          <a href="/producto/<?= Helpers::e($it['id']) ?>/<?= Helpers::e($it['slug'] ?? 'item') ?>" target="_blank" class="btn-sm btn-outline"><i class="fas fa-eye"></i> Ver</a>

          <?php if (($it['status'] ?? '') === 'approved' && ($auth->user()['role'] ?? '') === 'superadmin'): ?>
          <form class="inline-form" method="post" action="/admin/publicacion/vendido?id=<?= Helpers::e($it['id']) ?>" data-confirm="¿Marcar esta publicación como VENDIDO? El producto quedará visible pero sin contacto.">
            <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
            <button type="submit" class="btn-sm btn-sold"><i class="fas fa-tag"></i> Vendido</button>
          </form>
          <?php endif; ?>
        </div>

        <!-- Edit Form (collapsible) -->
        <details class="admin-edit-details">
          <summary class="btn-sm btn-outline"><i class="fas fa-edit"></i> Edición rápida</summary>
          <form method="post" action="/admin/publicacion/editar?id=<?= Helpers::e($it['id']) ?>" class="admin-edit-form">
            <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
            <div class="form-grid">
              <div class="form-group">
                <label class="form-label">Título</label>
                <input name="title" value="<?= Helpers::e($it['title']) ?>">
              </div>
              <div class="form-group">
                <label class="form-label">Categoría</label>
                <input name="category" value="<?= Helpers::e($it['category'] ?? '') ?>">
              </div>
              <div class="form-group">
                <label class="form-label">Estado</label>
                <select name="status">
                  <?php foreach (['pending','approved','rejected','hidden','blocked','sold'] as $s): ?>
                  <option value="<?= $s ?>" <?= ($it['status'] ?? '')===$s?'selected':'' ?>><?= $s === 'sold' ? 'Vendido' : ucfirst($s) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="form-group">
                <label class="form-label">Prioridad</label>
                <input name="priority" type="number" min="0" value="<?= (int)($it['priority'] ?? 0) ?>">
              </div>
              <div class="form-group">
                <label class="form-label"><i class="fas fa-headset"></i> Contacto</label>
                <select name="contact_mode">
                  <option value="seller" <?= ($it['contactMode'] ?? 'seller') === 'seller' ? 'selected' : '' ?>>Vendedor</option>
                  <option value="mediator" <?= ($it['contactMode'] ?? '') === 'mediator' ? 'selected' : '' ?>>Mediador (SuperAdmin)</option>
                </select>
              </div>
            </div>
            <label style="display:flex;align-items:center;gap:.5rem;margin:.5rem 0">
              <input type="checkbox" name="featured" <?= !empty($it['featured'])?'checked':'' ?>> <i class="fas fa-star"></i> Destacado
            </label>
            <button type="submit" class="btn-sm"><i class="fas fa-save"></i> Guardar</button>
          </form>
        </details>
      </div>
      <?php endforeach; ?>
    </div>
    <?php endif; ?>
  </div>
</div>
