<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes" class="active"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-flag"></i> Reportes de usuarios</h1>
    </div>

    <?php if (empty($reports)): ?>
    <div class="empty-state">
      <i class="fas fa-check-circle"></i>
      <h3>No hay reportes pendientes</h3>
      <p>Todo está bajo control.</p>
    </div>
    <?php else: ?>
    <div class="data-list">
      <?php foreach($reports as $r): ?>
      <div class="data-item">
        <div class="data-item-header">
          <div>
            <span class="status-badge status-<?= ($r['status'] ?? 'open') === 'open' ? 'pending' : 'approved' ?>">
              <?= ($r['status'] ?? 'open') === 'open' ? 'Abierto' : 'Resuelto' ?>
            </span>
            <strong>Reporte #<?= Helpers::e($r['id']) ?></strong>
          </div>
          <small class="text-muted"><?= date('d/m/Y H:i', (int)($r['createdAt'] ?? 0)) ?></small>
        </div>
        <div class="data-item-body">
          <p><i class="fas fa-link text-muted"></i> Publicación: <code><?= Helpers::e($r['listingId']) ?></code></p>
          <p><i class="fas fa-exclamation-triangle text-muted"></i> Motivo: <strong><?= Helpers::e(ucfirst($r['reason'] ?? '')) ?></strong></p>
          <?php if (!empty($r['comment'])): ?>
          <p><i class="fas fa-comment text-muted"></i> <?= Helpers::e($r['comment']) ?></p>
          <?php endif; ?>
          <?php if (!empty($r['reporterId'])): ?>
          <p class="text-muted"><small>Reportado por: <?= Helpers::e($r['reporterId']) ?></small></p>
          <?php endif; ?>
        </div>
        <div class="data-item-actions">
          <a href="/producto/<?= Helpers::e($r['listingId']) ?>/item" target="_blank" class="btn-sm btn-outline"><i class="fas fa-eye"></i> Ver publicación</a>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
    <?php endif; ?>
  </div>
</div>
