<?php use App\Core\Helpers; ?>

<div class="auth-container">
  <div class="auth-card">
    <div class="auth-header">
      <div class="auth-icon"><i class="fas fa-sign-in-alt"></i></div>
      <h1>Iniciar sesión</h1>
      <p class="text-muted">Accede a tu cuenta para publicar y gestionar</p>
    </div>
    <form method="post">
      <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
      <div class="form-group">
        <label class="form-label"><i class="fas fa-envelope"></i> Correo electrónico</label>
        <input name="email" type="email" placeholder="tu@correo.com" required autofocus>
      </div>
      <div class="form-group">
        <label class="form-label"><i class="fas fa-lock"></i> Contraseña</label>
        <input name="password" type="password" placeholder="Tu contraseña" required>
      </div>
      <button type="submit" class="btn-block"><i class="fas fa-sign-in-alt"></i> Entrar</button>
    </form>
    <div class="auth-footer">
      <a href="/recuperar"><i class="fas fa-key"></i> ¿Olvidaste tu contraseña?</a>
      <p>¿No tienes cuenta? <a href="/registro"><strong>Crear cuenta</strong></a></p>
    </div>
  </div>
</div>
