<?php use App\Core\Helpers; ?>

<div class="auth-container">
  <div class="auth-card">
    <div class="auth-header">
      <div class="auth-icon"><i class="fas fa-unlock-alt"></i></div>
      <h1>Restablecer contraseña</h1>
      <p class="text-muted">Ingresa el token recibido y tu nueva contraseña</p>
    </div>
    <form method="post">
      <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
      <div class="form-group">
        <label class="form-label"><i class="fas fa-ticket-alt"></i> Token</label>
        <input name="token" value="<?= Helpers::e($token ?? '') ?>" placeholder="Pega el token aquí" required>
      </div>
      <div class="form-group">
        <label class="form-label"><i class="fas fa-lock"></i> Nueva contraseña</label>
        <input name="password" type="password" placeholder="Mín. 8 caracteres" required minlength="8">
      </div>
      <button type="submit" class="btn-block"><i class="fas fa-save"></i> Guardar nueva contraseña</button>
    </form>
    <div class="auth-footer">
      <a href="/login"><i class="fas fa-arrow-left"></i> Volver al login</a>
    </div>
  </div>
</div>
