<?php use App\Core\Helpers; $user = $auth->user(); ?>

<div class="panel-layout">
  <aside class="panel-sidebar">
    <div class="panel-user-info">
      <div class="panel-avatar"><div class="avatar-placeholder"><i class="fas fa-user"></i></div></div>
      <h3><?= Helpers::e($user['name'] ?? '') ?></h3>
    </div>
    <nav class="panel-nav">
      <a href="/panel"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/panel/publicaciones"><i class="fas fa-list"></i> Mis publicaciones</a>
      <a href="/panel/publicacion/nueva"><i class="fas fa-plus-circle"></i> Nueva publicación</a>
      <a href="/panel/perfil"><i class="fas fa-user-edit"></i> Editar perfil</a>
      <a href="/panel/cambiar-clave" class="active"><i class="fas fa-key"></i> Cambiar contraseña</a>
    </nav>
  </aside>

  <div class="panel-main">
    <h1><i class="fas fa-key"></i> Cambiar contraseña</h1>
    <div class="form-card" style="max-width:500px">
      <form method="post">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group">
          <label class="form-label"><i class="fas fa-lock"></i> Contraseña actual</label>
          <input name="current_password" type="password" placeholder="Tu contraseña actual" required>
        </div>
        <div class="form-group">
          <label class="form-label"><i class="fas fa-lock"></i> Nueva contraseña (mín. 8 caracteres)</label>
          <input name="new_password" type="password" placeholder="Nueva contraseña segura" required minlength="8">
        </div>
        <button type="submit"><i class="fas fa-save"></i> Actualizar contraseña</button>
      </form>
    </div>
  </div>
</div>
