<?php use App\Core\Helpers; $editing = !empty($item); $user = $auth->user(); ?>

<div class="panel-layout">
  <aside class="panel-sidebar">
    <div class="panel-user-info">
      <div class="panel-avatar"><div class="avatar-placeholder"><i class="fas fa-user"></i></div></div>
      <h3><?= Helpers::e($user['name'] ?? '') ?></h3>
    </div>
    <nav class="panel-nav">
      <a href="/panel"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/panel/publicaciones"><i class="fas fa-list"></i> Mis publicaciones</a>
      <a href="/panel/publicacion/nueva" class="<?= !$editing ? 'active' : '' ?>"><i class="fas fa-plus-circle"></i> Nueva publicación</a>
      <a href="/panel/perfil"><i class="fas fa-user-edit"></i> Editar perfil</a>
      <a href="/panel/cambiar-clave"><i class="fas fa-key"></i> Cambiar contraseña</a>
    </nav>
  </aside>

  <div class="panel-main">
    <h1><i class="fas fa-<?= $editing ? 'edit' : 'plus-circle' ?>"></i> <?= $editing ? 'Editar' : 'Nueva' ?> publicación</h1>

    <?php if ($editing && ($item['status'] ?? '') === 'approved'): ?>
    <div class="flash flash-warning" style="background:rgba(255,165,2,.15);border:1px solid rgba(255,165,2,.4)">
      <i class="fas fa-info-circle"></i> Esta publicación está aprobada. Si editas campos principales, volverá a estado pendiente para re-moderación.
    </div>
    <?php endif; ?>

    <div class="form-card">
      <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">

        <div class="form-group">
          <label class="form-label"><i class="fas fa-heading"></i> Título *</label>
          <input name="title" value="<?= Helpers::e($item['title'] ?? '') ?>" placeholder="Ej: Motor Toyota 2.7 en buen estado" required>
        </div>

        <div class="form-grid">
          <div class="form-group">
            <label class="form-label"><i class="fas fa-folder"></i> Categoría *</label>
            <select name="category" required>
              <option value="">Seleccionar categoría</option>
              <?php foreach($categories as $c): ?>
              <option value="<?= Helpers::e($c['slug']) ?>" <?= (($item['category'] ?? '')===$c['slug'])?'selected':'' ?>><?= Helpers::e($c['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="form-group">
            <label class="form-label"><i class="fas fa-layer-group"></i> Subcategoría</label>
            <input name="subcategory" value="<?= Helpers::e($item['subcategory'] ?? '') ?>" placeholder="Ej: Toyota, Samsung...">
          </div>
        </div>

        <div class="form-grid">
          <div class="form-group">
            <label class="form-label"><i class="fas fa-check-circle"></i> Condición *</label>
            <select name="condition" required>
              <option value="nuevo" <?= (($item['condition'] ?? '')==='nuevo')?'selected':'' ?>>Nuevo</option>
              <option value="usado" <?= (($item['condition'] ?? '')==='usado')?'selected':'' ?>>Usado</option>
            </select>
          </div>
          <div class="form-group">
            <label class="form-label"><i class="fas fa-money-bill"></i> Precio (BOB) *</label>
            <input name="price" type="number" step="0.01" min="0" value="<?= Helpers::e((string)($item['price'] ?? '')) ?>" placeholder="0.00" required>
          </div>
        </div>

        <div class="form-grid">
          <div class="form-group">
            <label class="form-label"><i class="fas fa-map-marker-alt"></i> Ubicación</label>
            <input name="location" value="<?= Helpers::e($item['location'] ?? '') ?>" placeholder="Cochabamba, La Paz...">
          </div>
          <div class="form-group">
            <label class="form-label"><i class="fas fa-tags"></i> Tags (separados por coma)</label>
            <input name="tags" value="<?= Helpers::e(isset($item['tags']) ? implode(',', $item['tags']) : '') ?>" placeholder="motor, toyota, repuesto">
          </div>
        </div>

        <div class="form-grid">
          <div class="form-group">
            <label class="form-label"><i class="fas fa-exchange-alt"></i> Tipo de oferta</label>
            <select name="offerType">
              <option value="venta" <?= (($item['offerType'] ?? '')==='venta')?'selected':'' ?>>Venta</option>
              <option value="intercambio" <?= (($item['offerType'] ?? '')==='intercambio')?'selected':'' ?>>Intercambio</option>
            </select>
          </div>
          <div class="form-group" style="display:flex;align-items:end;padding-bottom:.6rem">
            <label style="display:flex;align-items:center;gap:.5rem;cursor:pointer">
              <input type="checkbox" name="shipping" <?= !empty($item['shipping'])?'checked':'' ?>>
              <i class="fas fa-truck"></i> Envío disponible
            </label>
          </div>
        </div>

        <div class="form-group">
          <label class="form-label"><i class="fas fa-align-left"></i> Descripción</label>
          <textarea name="description" rows="6" placeholder="Describe tu producto con detalle: estado, características, motivo de venta..."><?= Helpers::e($item['description'] ?? '') ?></textarea>
        </div>

        <div class="form-group">
          <label class="form-label"><i class="fas fa-images"></i> Fotos (máx. <?= $config['app']['max_images_per_listing'] ?>)</label>
          <input type="file" name="images[]" multiple accept="image/*">
          <?php if ($editing && !empty($item['images'])): ?>
          <div class="gallery-thumbs" style="margin-top:.5rem">
            <?php foreach ($item['images'] as $im): ?>
            <div class="gallery-thumb">
              <img src="/media/listing/<?= Helpers::e($item['id']) ?>/<?= Helpers::e($im) ?>" alt="Foto">
            </div>
            <?php endforeach; ?>
          </div>
          <?php endif; ?>
        </div>

        <button type="submit"><i class="fas fa-<?= $editing ? 'save' : 'paper-plane' ?>"></i> <?= $editing ? 'Guardar cambios' : 'Publicar para moderación' ?></button>
      </form>
    </div>
  </div>
</div>
