<?php use App\Core\Helpers; ?>
<article class="listing-card">
  <a href="/producto/<?= Helpers::e($it['id']) ?>/<?= Helpers::e($it['slug'] ?? 'item') ?>" class="listing-card-img">
    <img src="<?= !empty($it['image']) ? '/media/listing/' . Helpers::e($it['id']) . '/' . Helpers::e($it['image']) : '/assets/img/demo/demo_' . rand(1,6) . '.jpg' ?>" alt="<?= Helpers::e($it['title']) ?>" loading="lazy">
    <div class="listing-card-badges">
      <span class="badge badge-<?= ($it['condition'] ?? '') === 'nuevo' ? 'new' : 'used' ?>"><?= Helpers::e(ucfirst($it['condition'] ?? 'usado')) ?></span>
      <?php if (!empty($it['featured'])): ?><span class="badge badge-featured"><i class="fas fa-star"></i> Destacado</span><?php endif; ?>
      <?php if (!empty($it['sellerVerified'])): ?><span class="badge badge-verified"><i class="fas fa-check-circle"></i></span><?php endif; ?>
      <?php if (($it['status'] ?? '') === 'sold'): ?><span class="badge badge-sold"><i class="fas fa-ban"></i> Vendido</span><?php endif; ?>
    </div>
    <?php if (($it['status'] ?? '') === 'sold'): ?>
    <div class="listing-card-sold-overlay"><span>VENDIDO</span></div>
    <?php endif; ?>
  </a>
  <div class="listing-card-body">
    <h3 class="listing-card-title">
      <a href="/producto/<?= Helpers::e($it['id']) ?>/<?= Helpers::e($it['slug'] ?? 'item') ?>"><?= Helpers::e($it['title']) ?></a>
    </h3>
    <p class="listing-card-location"><i class="fas fa-map-marker-alt"></i> <?= Helpers::e($it['location'] ?? 'Bolivia') ?></p>
    <div class="listing-card-footer">
      <span class="listing-card-price"><?= number_format((float)($it['price'] ?? 0), 0, ',', '.') ?> <small>BOB</small></span>
      <span class="listing-card-views"><i class="fas fa-eye"></i> <?= (int)($it['views'] ?? 0) ?></span>
    </div>
  </div>
</article>
