<?php use App\Core\Helpers; ?>

<div class="product-layout">
  <!-- Gallery + Info -->
  <div class="product-main">
    <div class="product-gallery">
      <?php if (!empty($item['images'])): ?>
      <div class="gallery-main">
        <img src="/media/listing/<?= Helpers::e($item['id']) ?>/<?= Helpers::e($item['images'][0]) ?>" alt="<?= Helpers::e($item['title']) ?>">
      </div>
      <?php if (count($item['images']) > 1): ?>
      <div class="gallery-thumbs">
        <?php foreach ($item['images'] as $i => $im): ?>
        <button class="gallery-thumb <?= $i === 0 ? 'active' : '' ?>" data-src="/media/listing/<?= Helpers::e($item['id']) ?>/<?= Helpers::e($im) ?>">
          <img src="/media/listing/<?= Helpers::e($item['id']) ?>/<?= Helpers::e($im) ?>" alt="Foto <?= $i+1 ?>">
        </button>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
      <?php else: ?>
      <div class="gallery-main">
        <img src="/assets/img/demo/demo_1.jpg" alt="Sin imagen">
      </div>
      <?php endif; ?>

      <?php if (!empty($isSold)): ?>
      <div class="sold-overlay">
        <span class="sold-stamp">VENDIDO</span>
      </div>
      <?php endif; ?>
    </div>

    <div class="product-info">
      <div class="product-badges">
        <span class="badge badge-<?= ($item['condition'] ?? '') === 'nuevo' ? 'new' : 'used' ?>"><?= Helpers::e(ucfirst($item['condition'] ?? '')) ?></span>
        <?php if (!empty($isSold)): ?><span class="badge badge-sold"><i class="fas fa-ban"></i> Vendido</span><?php endif; ?>
        <?php if (!empty($item['featured'])): ?><span class="badge badge-featured"><i class="fas fa-star"></i> Destacado</span><?php endif; ?>
        <?php if (!empty($item['shipping'])): ?><span class="badge badge-verified"><i class="fas fa-truck"></i> Envío</span><?php endif; ?>
        <span class="badge"><?= Helpers::e(ucfirst($item['offerType'] ?? 'venta')) ?></span>
      </div>

      <?php if (!empty($isSold)): ?>
      <div class="sold-notice">
        <i class="fas fa-ban"></i> Este producto ya fue vendido
      </div>
      <?php endif; ?>

      <h1 class="product-title"><?= Helpers::e($item['title']) ?></h1>
      <div class="product-price"><?= number_format((float)$item['price'], 0, ',', '.') ?> <span class="product-currency"><?= Helpers::e($item['currency']) ?></span></div>

      <div class="product-meta">
        <div class="meta-item"><i class="fas fa-folder"></i> <?= Helpers::e(ucfirst($item['category'])) ?><?= !empty($item['subcategory']) ? ' / ' . Helpers::e($item['subcategory']) : '' ?></div>
        <div class="meta-item"><i class="fas fa-map-marker-alt"></i> <?= Helpers::e($item['location']) ?></div>
        <div class="meta-item"><i class="fas fa-calendar"></i> <?= date('d/m/Y H:i', (int)$item['createdAt']) ?></div>
        <div class="meta-item"><i class="fas fa-eye"></i> <?= (int)$item['views'] ?> vistas</div>
        <?php if (!empty($item['tags'])): ?>
        <div class="meta-item"><i class="fas fa-tags"></i> <?= Helpers::e(implode(', ', $item['tags'])) ?></div>
        <?php endif; ?>
      </div>

      <div class="product-description">
        <h3>Descripción</h3>
        <p><?= nl2br(Helpers::e($item['description'])) ?></p>
      </div>

      <div class="product-actions">
        <?php if (empty($isSold)): ?>
          <?php $phone = preg_replace('/\D/', '', $contactWhatsapp ?? ''); ?>
          <?php if ($phone): ?>
          <?php if (!empty($contactMode) && $contactMode === 'mediator'): ?>
          <div class="mediator-badge"><i class="fas fa-headset"></i> Contacto vía mediador: <?= Helpers::e($contactName ?? 'Taller Mojarra') ?></div>
          <?php endif; ?>
          <a href="https://wa.me/<?= $phone ?>?text=<?= urlencode('Hola, me interesa: ' . $item['title']) ?>" target="_blank" rel="noopener" class="btn-whatsapp">
            <i class="fab fa-whatsapp"></i> WhatsApp
          </a>
          <a href="tel:<?= Helpers::e($contactPhone ?? '') ?>" class="btn-call">
            <i class="fas fa-phone"></i> Llamar
          </a>
          <?php endif; ?>
        <?php endif; ?>
        <form method="post" action="/favorito/<?= Helpers::e($item['id']) ?>" class="inline-form">
          <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
          <button type="submit" class="btn-favorite"><i class="fas fa-heart"></i> Favorito</button>
        </form>
        <button type="button" class="btn-share" data-share="<?= Helpers::e($item['title']) ?>">
          <i class="fas fa-share-alt"></i> Compartir
        </button>
      </div>
    </div>
  </div>

  <!-- Sidebar -->
  <aside class="product-sidebar">
    <div class="seller-card">
      <div class="seller-avatar">
        <?php if (!empty($owner['avatar'])): ?>
        <img src="/media/avatar/<?= Helpers::e($owner['id']) ?>/<?= Helpers::e($owner['avatar']) ?>" alt="Avatar">
        <?php else: ?>
        <div class="avatar-placeholder"><i class="fas fa-user"></i></div>
        <?php endif; ?>
      </div>
      <?php if (!empty($contactMode) && $contactMode === 'mediator' && empty($isSold)): ?>
      <h3><i class="fas fa-headset"></i> <?= Helpers::e($contactName ?? 'Mediador') ?></h3>
      <p class="text-muted">Intermediario de ventas</p>
      <?php else: ?>
      <h3><?= Helpers::e($owner['name'] ?? 'Vendedor') ?></h3>
      <p class="text-muted"><i class="fas fa-map-marker-alt"></i> <?= Helpers::e($owner['location'] ?? '') ?></p>
      <?php if (!empty($owner['verified'])): ?><span class="badge badge-verified"><i class="fas fa-check-circle"></i> Verificado</span><?php endif; ?>
      <?php endif; ?>
    </div>

    <div class="report-section">
      <h4><i class="fas fa-flag"></i> Reportar publicación</h4>
      <form method="post" action="/reportar/<?= Helpers::e($item['id']) ?>">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group">
          <select name="reason" required>
            <option value="">Seleccionar motivo</option>
            <option value="estafa">Estafa / Fraude</option>
            <option value="ilegal">Contenido ilegal</option>
            <option value="violento">Violento / Inapropiado</option>
            <option value="duplicado">Duplicado</option>
            <option value="otro">Otro</option>
          </select>
        </div>
        <div class="form-group">
          <textarea name="comment" placeholder="Describe el problema..." rows="3"></textarea>
        </div>
        <button type="submit" class="btn-danger btn-sm"><i class="fas fa-flag"></i> Enviar reporte</button>
      </form>
    </div>
  </aside>
</div>
