<?php use App\Core\Helpers; ?>

<div class="search-page">
  <div class="search-header">
    <h1><i class="fas fa-search"></i> Buscar productos</h1>
    <p class="text-muted">Total: <strong><?= (int)$total ?></strong> resultados</p>
  </div>

  <!-- Filters -->
  <form action="/buscar" method="get" class="filters-bar">
    <div class="filters-grid">
      <div class="form-group">
        <label class="form-label">Texto</label>
        <input name="q" value="<?= Helpers::e($filters['q']) ?>" placeholder="Motor, llanta, laptop...">
      </div>
      <div class="form-group">
        <label class="form-label">Categoría</label>
        <select name="cat">
          <option value="">Todas</option>
          <?php foreach($categories as $c): ?>
          <option value="<?= Helpers::e($c['slug']) ?>" <?= $filters['cat']===$c['slug']?'selected':'' ?>><?= Helpers::e($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="form-group">
        <label class="form-label">Condición</label>
        <select name="cond">
          <option value="">Todas</option>
          <option value="nuevo" <?= $filters['cond']==='nuevo'?'selected':'' ?>>Nuevo</option>
          <option value="usado" <?= $filters['cond']==='usado'?'selected':'' ?>>Usado</option>
        </select>
      </div>
      <div class="form-group">
        <label class="form-label">Precio mín.</label>
        <input name="min" value="<?= Helpers::e($filters['min']) ?>" placeholder="0" type="number">
      </div>
      <div class="form-group">
        <label class="form-label">Precio máx.</label>
        <input name="max" value="<?= Helpers::e($filters['max']) ?>" placeholder="99999" type="number">
      </div>
      <div class="form-group">
        <label class="form-label">Ubicación</label>
        <input name="loc" value="<?= Helpers::e($filters['loc']) ?>" placeholder="Cochabamba...">
      </div>
      <div class="form-group">
        <label class="form-label">Tipo</label>
        <select name="type">
          <option value="">Todos</option>
          <option value="venta" <?= $filters['type']==='venta'?'selected':'' ?>>Venta</option>
          <option value="intercambio" <?= $filters['type']==='intercambio'?'selected':'' ?>>Intercambio</option>
        </select>
      </div>
      <div class="form-group">
        <label class="form-label">Envío</label>
        <select name="shipping">
          <option value="">Todos</option>
          <option value="1" <?= $filters['shipping']==='1'?'selected':'' ?>>Con envío</option>
          <option value="0" <?= $filters['shipping']==='0'?'selected':'' ?>>Sin envío</option>
        </select>
      </div>
      <div class="form-group">
        <label class="form-label">Vendedor</label>
        <select name="verified">
          <option value="">Todos</option>
          <option value="1" <?= $filters['verified']==='1'?'selected':'' ?>>Verificado</option>
        </select>
      </div>
    </div>
    <div class="filters-actions">
      <button type="submit"><i class="fas fa-filter"></i> Filtrar</button>
      <a href="/buscar" class="btn-outline"><i class="fas fa-times"></i> Limpiar</a>
    </div>
  </form>

  <!-- Results -->
  <?php if (empty($items)): ?>
  <div class="empty-state">
    <i class="fas fa-inbox"></i>
    <h3>No se encontraron resultados</h3>
    <p>Intenta con otros filtros o busca algo diferente.</p>
  </div>
  <?php else: ?>
  <div class="grid-cards">
    <?php foreach($items as $it){ require __DIR__ . '/../partials/listing_card.php'; } ?>
  </div>
  <?php endif; ?>

  <!-- Pagination -->
  <?php $pages = max(1, (int)ceil($total/$per)); if($pages > 1): ?>
  <nav class="pagination">
    <?php if ($page > 1): ?>
    <a href="?<?= http_build_query(array_merge($filters, ['page' => $page - 1])) ?>"><i class="fas fa-chevron-left"></i></a>
    <?php endif; ?>
    <?php for ($i = max(1, $page - 3); $i <= min($pages, $page + 3); $i++): ?>
    <a href="?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>" class="<?= $i === $page ? 'active' : '' ?>"><?= $i ?></a>
    <?php endfor; ?>
    <?php if ($page < $pages): ?>
    <a href="?<?= http_build_query(array_merge($filters, ['page' => $page + 1])) ?>"><i class="fas fa-chevron-right"></i></a>
    <?php endif; ?>
  </nav>
  <?php endif; ?>
</div>
