<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-crown"></i> SuperAdmin</div>
    <nav class="admin-nav">
      <a href="/superadmin/admins"><i class="fas fa-user-shield"></i> Gestión de Admins</a>
      <a href="/superadmin/config" class="active"><i class="fas fa-sliders-h"></i> Configuración</a>
      <a href="/admin"><i class="fas fa-arrow-left"></i> Volver a Admin</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-sliders-h"></i> Configuración global del sitio</h1>
    </div>

    <div class="admin-card">
      <h3><i class="fas fa-cog"></i> Configuración general</h3>
      <form method="post" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group">
          <label class="form-label">Nombre del sitio</label>
          <input name="site_name" value="<?= Helpers::e($settings['site_name'] ?? 'Venta y Compra - Taller Mecánico Mojarra') ?>" required>
        </div>
        <label style="display:flex;align-items:center;gap:.5rem;margin:1rem 0;cursor:pointer">
          <input type="checkbox" name="maintenance_mode" <?= !empty($settings['maintenance_mode'])?'checked':'' ?>>
          <i class="fas fa-tools"></i> Modo mantenimiento (solo SuperAdmin puede acceder)
        </label>

        <h3 style="margin-top:2rem"><i class="fas fa-headset"></i> Mediador de ventas</h3>
        <p class="text-muted" style="margin:.5rem 0">Configura el teléfono del SuperAdmin como mediador. Al elegir modo "Mediador" en una publicación, los compradores verán este número en vez del vendedor.</p>
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">Teléfono del mediador</label>
            <input name="mediator_phone" value="<?= Helpers::e($settings['mediator_phone'] ?? '') ?>" placeholder="+591 70000001">
          </div>
          <div class="form-group">
            <label class="form-label">WhatsApp del mediador</label>
            <input name="mediator_whatsapp" value="<?= Helpers::e($settings['mediator_whatsapp'] ?? '') ?>" placeholder="+591 70000001">
          </div>
          <div class="form-group">
            <label class="form-label">Modo de contacto por defecto</label>
            <select name="default_contact_mode">
              <option value="seller" <?= ($settings['default_contact_mode'] ?? 'seller') === 'seller' ? 'selected' : '' ?>>Vendedor (el dueño del producto)</option>
              <option value="mediator" <?= ($settings['default_contact_mode'] ?? '') === 'mediator' ? 'selected' : '' ?>>Mediador (SuperAdmin)</option>
            </select>
          </div>
        </div>

        <button type="submit"><i class="fas fa-save"></i> Guardar configuración</button>
      </form>
    </div>

    <!-- Backups -->
    <div class="admin-card" style="margin-top:1.5rem">
      <h3><i class="fas fa-database"></i> Backups disponibles</h3>
      <?php if (empty($backups)): ?>
      <p class="text-muted" style="margin-top:.5rem">No hay backups disponibles.</p>
      <?php else: ?>
      <form method="post" action="/superadmin/backup/restaurar" data-confirm="¿Restaurar este backup? Esto sobreescribirá los datos actuales." style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group">
          <label class="form-label">Seleccionar backup para restaurar</label>
          <select name="file">
            <?php foreach($backups as $b): ?>
            <option value="<?= Helpers::e($b) ?>"><?= Helpers::e($b) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <button type="submit" class="btn-warning"><i class="fas fa-undo"></i> Restaurar backup</button>
      </form>
      <?php endif; ?>

      <form method="post" action="/superadmin/backup/crear" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <button type="submit"><i class="fas fa-download"></i> Crear nuevo backup</button>
      </form>
    </div>
  </div>
</div>
