<?php
$config = require __DIR__ . '/../app/bootstrap.php';
$scriptDir = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/');
$baseUrl = ($scriptDir === '' || $scriptDir === '.') ? '/' : $scriptDir;
$config['app']['base_url'] = $baseUrl;
$GLOBALS['__app_base_url'] = $baseUrl;

use App\Core\Auth;
use App\Core\Router;
use App\Core\Security;
use App\Core\Storage;
use App\Controllers\AdminController;
use App\Controllers\AuthController;
use App\Controllers\MediaController;
use App\Controllers\PanelController;
use App\Controllers\PublicController;
use App\Controllers\SuperAdminController;

$storage = new Storage($config);
$auth = new Auth($storage, $config);
$security = new Security($config, $storage);

$settings = $storage->readJson('pages/settings.json', []);
$user = $auth->user();
if (!empty($settings['maintenance_mode']) && (!$user || ($user['role'] ?? '') !== 'superadmin')) {
    http_response_code(503);
    echo 'Sitio en mantenimiento. Intenta más tarde.';
    exit;
}

$public = new PublicController($config, $storage, $auth, $security);
$authCtl = new AuthController($config, $storage, $auth, $security);
$panel = new PanelController($config, $storage, $auth, $security);
$admin = new AdminController($config, $storage, $auth, $security);
$super = new SuperAdminController($config, $storage, $auth, $security);
$media = new MediaController($config, $storage, $auth, $security);

$router = new Router();

$router->add('GET', '/', fn() => $public->home());
$router->add('GET', '/buscar', fn() => $public->search());
$router->add('GET', '/categoria/{slug}', fn($p) => $public->category($p));
$router->add('GET', '/producto/{id}/{slug}', fn($p) => $public->product($p));
$router->add('POST', '/reportar/{listingId}', fn($p) => $public->report($p));
$router->add('POST', '/favorito/{listingId}', fn($p) => $public->favorite($p));
$router->add('GET', '/pagina/{slug}', fn($p) => $public->page($p));

$router->add('GET', '/registro', fn() => $authCtl->registerForm());
$router->add('POST', '/registro', fn() => $authCtl->register());
$router->add('GET', '/login', fn() => $authCtl->loginForm());
$router->add('POST', '/login', fn() => $authCtl->login());
$router->add('POST', '/logout', fn() => $authCtl->logout());
$router->add('GET', '/recuperar', fn() => $authCtl->recoverForm());
$router->add('POST', '/recuperar', fn() => $authCtl->recover());
$router->add('GET', '/reset', fn() => $authCtl->resetForm());
$router->add('POST', '/reset', fn() => $authCtl->reset());

$router->add('GET', '/panel', fn() => $panel->dashboard());
$router->add('GET', '/panel/perfil', fn() => $panel->profileForm());
$router->add('POST', '/panel/perfil', fn() => $panel->profileSave());
$router->add('GET', '/panel/cambiar-clave', fn() => $panel->changePasswordForm());
$router->add('POST', '/panel/cambiar-clave', fn() => $panel->changePasswordSave());
$router->add('GET', '/panel/publicaciones', fn() => $panel->listings());
$router->add('GET', '/panel/publicacion/nueva', fn() => $panel->listingForm());
$router->add('POST', '/panel/publicacion/nueva', fn() => $panel->listingCreate());
$router->add('GET', '/panel/publicacion/editar', fn() => $panel->listingEditForm());
$router->add('POST', '/panel/publicacion/editar', fn() => $panel->listingEditSave());
$router->add('POST', '/panel/publicacion/eliminar', fn() => $panel->listingDelete());

$router->add('GET', '/admin', fn() => $admin->dashboard());
$router->add('GET', '/admin/publicaciones', fn() => $admin->listings());
$router->add('POST', '/admin/publicacion/aprobar', fn() => $admin->approve());
$router->add('POST', '/admin/publicacion/rechazar', fn() => $admin->reject());
$router->add('POST', '/admin/publicacion/editar', fn() => $admin->editListing());
$router->add('POST', '/admin/publicacion/vendido', fn() => $admin->markSold());
$router->add('GET', '/admin/usuarios', fn() => $admin->users());
$router->add('POST', '/admin/usuarios', fn() => $admin->users());
$router->add('GET', '/admin/categorias', fn() => $admin->categories());
$router->add('POST', '/admin/categorias', fn() => $admin->categories());
$router->add('GET', '/admin/publicidad', fn() => $admin->ads());
$router->add('POST', '/admin/publicidad', fn() => $admin->ads());
$router->add('GET', '/admin/paginas', fn() => $admin->pages());
$router->add('POST', '/admin/paginas', fn() => $admin->pages());
$router->add('GET', '/admin/reportes', fn() => $admin->reports());
$router->add('GET', '/admin/logs', fn() => $admin->logs());
$router->add('POST', '/admin/rebuild-indexes', fn() => $admin->rebuildIndexes());

$router->add('GET', '/superadmin/admins', fn() => $super->admins());
$router->add('POST', '/superadmin/admins', fn() => $super->admins());
$router->add('GET', '/superadmin/config', fn() => $super->config());
$router->add('POST', '/superadmin/config', fn() => $super->config());
$router->add('POST', '/superadmin/backup/crear', fn() => $super->backupCreate());
$router->add('POST', '/superadmin/backup/restaurar', fn() => $super->backupRestore());
$router->add('POST', '/superadmin/reset-password', fn() => $super->resetPassword());

$router->add('GET', '/media/listing/{id}/{file}', fn($p) => $media->listing($p));
$router->add('GET', '/media/avatar/{id}/{file}', fn($p) => $media->avatar($p));

$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
$requestPath = parse_url($requestUri, PHP_URL_PATH) ?: '/';
$requestQuery = parse_url($requestUri, PHP_URL_QUERY);

// Remove the script directory prefix when running under a subdirectory (e.g. /project/public).
if ($scriptDir !== '' && $scriptDir !== '.' && str_starts_with($requestPath, $scriptDir)) {
    $requestPath = substr($requestPath, strlen($scriptDir));
    $requestPath = $requestPath === '' ? '/' : $requestPath;
}

$normalizedUri = $requestPath . ($requestQuery ? '?' . $requestQuery : '');
$router->dispatch($_SERVER['REQUEST_METHOD'], $normalizedUri);
